package gov.va.med.mhv.phr.allergy.decorator;

import gov.va.med.mhv.healthhistory.form.AllergyForm;
import gov.va.med.mhv.healthhistory.enumeration.SeverityEnumeration;
import org.displaytag.decorator.ColumnDecorator;
import org.displaytag.exception.DecoratorException;

public class SeveritySEIDecorator implements ColumnDecorator {

	/**
	 * Used with DisplayTag to map code to string
	 * @param value
	 * @return
	 * @throws DecoratorException
	 */
	public String decorate(Object value) throws DecoratorException {
    	return value == null ? "" : getDisplayValue(value);
	}

	/**
	 *
	 * @param value
	 * @return
	 */
	private String getDisplayValue(Object value){
		return AllergyForm.getAllergySeverityName( (SeverityEnumeration)value );
	}
}
